<?php

class EWRporta_Model_Search extends XenForo_Model
{
	public function getSearchResults($keywords)
	{
        $pages = $this->_getDb()->fetchAll("
			SELECT *, 
				MATCH(page_name) AGAINST (?) AS score_name, 
				MATCH(page_content) AGAINST (?) AS score_content
				FROM EWRporta_pages
			WHERE MATCH(page_name) AGAINST(?)
				OR MATCH(page_content) AGAINST(?)
			ORDER BY score_name DESC, score_content DESC
		", array($keywords, $keywords, $keywords, $keywords));

		foreach ($pages AS &$page)
		{
			$page['score_match'] = round(($page['score_name'] * 20) + ($page['score_content'] * 10));

			if ($page['score_match'] > 99) { $page['score_match'] = 99; }
		}

		return $pages;
	}
}